/*
 * @(#)SystemColorsInspector.java 1.0  2005-03-06
 *
 * Copyright (c) 2005 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.debug;

//import ch.randelshofer.gui.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
/**
 * Displays the current system colors.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2005-03-16 Created.
 */
public class SystemColorsInspector extends javax.swing.JPanel {
    
    /** Creates new form SystemColorsInspector */
    public SystemColorsInspector() {
        initComponents();
        
        table.setModel(new SystemColorsTableModel());
        UIDefaultsCellRenderer r = new UIDefaultsCellRenderer();
        r.setFont(new Font("Dialog", Font.PLAIN, 22));
        table.getColumnModel().getColumn(0).setCellRenderer(r);
        table.getColumnModel().getColumn(1).setCellRenderer(r);
    }
    
    public static void main(String[] args) {
        JFrame f = new JFrame("System Colors Inspector");
        f.addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent evt) { System.exit(0); } } );
        f.getContentPane().add(new SystemColorsInspector());
        f.setSize(400, 300);
        f.show();
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        scrollPane = new javax.swing.JScrollPane();
        table = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        scrollPane.setFont(new java.awt.Font("Dialog", 0, 11));
        table.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        scrollPane.setViewportView(table);

        add(scrollPane, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
        
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JTable table;
    // End of variables declaration//GEN-END:variables
    
}
